DECLARE @VISTA_CODE NVARCHAR(10)
BEGIN TRY
	BEGIN TRANSACTION;
		SET @VISTA_CODE = '$(varVISTACode)'
		CREATE TABLE #FACILITIES(FACILITY_SECTION NVARCHAR(100))
		INSERT INTO #FACILITIES (FACILITY_SECTION)
		SELECT 'FacilitySettings ' + E.IDENTIFIER
		FROM BMS_EIS.dbo.ENTITY AS E 
			INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = E.PK_ENTITY
			INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = O.PFK_ORGANIZATION AND R.CLASS_CODE = 'MBR'
			INNER JOIN BMS_EIS.dbo.EHL7_UID AS V ON R.FK_SCOPER_ENTITY = V.FK_ENTITY AND V.IDENTIFIER_ROOT = 'CODE'
		WHERE O.CODE_CODE = 'FAC' AND V.IDENTIFIER_EXTENSION = @VISTA_CODE

		DELETE C FROM BMS.dbo.CONFIG AS C
		INNER JOIN #FACILITIES AS FAC ON FAC.FACILITY_SECTION = C.SECTION
		WHERE C.CONFIG_KEY= 'MedicalCenterID'

		DELETE C FROM BMS_HISTORY.dbo.CONFIG_H AS C
		INNER JOIN #FACILITIES AS FAC ON FAC.FACILITY_SECTION = C.SECTION
		WHERE C.CONFIG_KEY= 'MedicalCenterID'
	
	DROP TABLE #FACILITIES
	SELECT 'Facility Medical Center Division - successfully deleted'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	 SELECT  ERROR_LINE() AS ErrorLine,
			 ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;